# Creating Inclusive Community
## 2.5 hour workshop

## Objective:
Create a supportive forum in which students can define what inclusive community means at Ada and give direct feedback to each other and to staff about how to improve inclusivity in our community. Students will use skills from the Implicit Bias workshop by thinking about how aspects of Ada's culture may feel to students of culturally marginalized identities and by approaching inclusivity with an intersectional lens. 

## Community Affirmation Activity (30 min)

Have all participants sit and close their eyes. Dim the lights and start with a short breathing exercise. Have about 1/5 of the group open their eyes and stand. Give an  instruction to those standing like, "Touch the shoulder of several people who made you feel really welcome the first week." They will slowly circulate and touch the shoulders of classmates gently. Give several more affirmations and then have those students sit and others stand. Do this until all students have had the opportunity to stand.
*As facilitator, be aware of group dynamics. At times, ask participants to touch the shoulders of only people they haven't affirmed yet. Step in and give your own shoulder touches when appropriate.*

## Building Our Container (20 min)

Draw a large jar or box on the whiteboard to write over. Ask the group, "What makes you feel safe during uncomfortable or difficult conversations?" "What will hold us together as a community during this workshop, rather than break us down?"
*This is an alternative to writing "ground rules." This will sometimes branch into a larger conversation about how we want to handle ignorant or potentially hurtful statements. Let it happen.*

## Break Out Discussion (45 min)

During the container, distribute a bowl for students to randomly draw numbers for the small group discussion. Based on the number they drew, they will meet their randomly assigned group in a particular location of the building where they'll find a packet to guide the conversation. Before sending them off to their groups, let them know that the goal of the conversation is to define what inclusive community means to us and how we can move closer to that at Ada, both institutionally and socially. Ask them to be aware of speaking time and creating space for quieter group members. Take questions.

Packet Questions:
  1. What is an "inclusive community?"
  *I recommend getting some starting ideas down now, and then returning to it again at the end of your conversation. When we’re back in the full group I’m going to ask a couple groups to share their definition, so decide as a group if you’re comfortable volunteering.*
  2. What's the most inclusive community you've been in? What made it that way?
  *No need to take notes for this one unless you want to*
  3. Is Ada an inclusive community? Why/why not?
  4. What does Ada (students or staff) do well in creating inclusive community?
  *Think about whether you're comfortable sharing this back in the large group*
  5. What would you like to see Ada staff do to increase inclusivity?
  *This can be anything from policy/structure change to interpersonal interactions. Think about whether you're comfortable sharing this in the large group.*
  6. What would you like to see Ada students do to increase inclusivity?
  *Think about whether you're comfortable sharing this in the large group.*

## Large Group discussion (30 min)

Go through the questions and ask for groups to share what they discussed. Each one should produce some responses and conversation. As time winds down, let them know your plan for follow-up. (Take feedback to other staff anonymously, outcomes report at next workshop.) Let them know you will be send out [This Google Doc](https://docs.google.com/a/adadevelopersacademy.org/forms/d/1EuzUZ3MhtxR-pmM3Au418PBjGltDex7U4yT3Hgveyqk/edit) as an opportunity for everyone to reflect individually on the success of their small group in representing everyone's ideas, and on inclusivity within their respective class.

## Return to the Container (5-10 min)

How did we do in conversation respecting the container? Anything we would add or change with hindsight? Final thoughts.
